/* 
* Wrapper NCL script for LaRC visst unpacker function
* created by jmcphee on jan 2007
* for further references see  http://www.ncl.ucar.edu/Document/Manuals/Ref_Manual/NclExtend.shtml#Example_6
*/

#include <stdlib.h>
#include <string.h>
#include "vintrt.h"
/*
 * The following are the required NCAR Graphics include files.
 * They should be located in ${NCARG_ROOT}/include
 */

#include <ncarg/hlu/hlu.h>
#include <ncarg/hlu/NresDB.h>
#include <ncarg/ncl/defs.h>
#include <ncarg/ncl/NclDataDefs.h>
#include <ncarg/ncl/NclBuiltInSupport.h>
#include <ncarg/ncl/NclBuiltIns.h>



#define NPARAMS 25
#define NLINES 550
#define NELEMENTS 1600

extern int unpackCP(const char *fn, const int *array_size, const int *selection, int *mcidas_navarr,
             int *mcidas_head, int *valid_size, float *data, float *lat_lon, char *comment);

NhlErrorTypes unpackCP_W( void ) {
  char FNAME[100];
  char *fn;
  /*  int *selection[MAX_PARAMETERS]; */
  int *selection;
  float data_ret[NPARAMS][NLINES][NELEMENTS], *p;
  int mcidas_navarr[MCIDAS_NAVARRAY_INTS];
  int mcidas_headarr[MCIDAS_HEADARRAY_INTS];
  int array_size[3], valid_size[3];
  float lat_lon[6];
  char comment[COMMENT_SIZE + 1]; /* add 1 for the NULL char */
  int status;
  int selection_dimsizes[1];
  int fn_dimsize;
  
  array_size[0] = NPARAMS;
  array_size[1] = NLINES;
  array_size[2] = NELEMENTS;
  p = &data_ret[0][0][0];
  
  /*
   * Retrieve arguments from NCL function call. It doesn't matter
   * what order you call them in.
   */ 
  fn=(char*) NclGetArgValue(
			    0,
			    2,
			    NULL,
			    NULL,
			    NULL,
			    NULL,
			    NULL,
			    2);
  
  selection=(int*) NclGetArgValue(
				  1,
				  2,
				  NULL,
				  selection_dimsizes,
				  NULL,
				  NULL,
				  NULL,
				  1);
  
  FNAME[0]=*fn;
  printf("file %s\n",FNAME);
  
  /*
   * Call the C unpacker function.
   */
  if ((status = unpackCP(FNAME, array_size, selection, mcidas_navarr,
			 mcidas_headarr, valid_size, p, lat_lon, comment)) != 0) {
    fprintf(stderr, "Error return from unpackCP: %d\n", status);
    exit(-1);
  }
  
  /*
   *  data[0][][] contains latitude
   *  data[1][][] contains longitude
   *    .
   *    .
   *    .
   *    .
   *  data[21][][] contains Zbot
   *  do something with data... in ncl
   */
  
  
  /*
   * Set up return value, includes data, act_size and status.
   */
  return(NclReturnValue(p,3,valid_size,NULL,NCL_float,1));
}


void Init(void){
  void *args;
  int dimsizes[NCL_MAX_DIMENSIONS];
  int nargs=0;
  
  /*
   * Register unpackCP function.
   */
  args = NewArgs(2);

  dimsizes[0] = -1;      /* -1 ===> Dimension can be any size. */
  
  SetArgTemplate(args,0,"string",1,dimsizes);nargs++;
  SetArgTemplate(args,1,"integer",1,dimsizes);nargs++;
  
  NclRegisterFunc(unpackCP_W,args,"unpack_visst",nargs);
  
}
