/*
 *  vintrt.h
 *
 *  $Id: vintrt.h,v 1.5 2004/06/16 13:53:53 gnowicki Exp gnowicki $
 *
 *  $Log: vintrt.h,v $
 *  Revision 1.5  2004/06/16 13:53:53  gnowicki
 *  Renamed function calls and added some new ones.
 *
 *  Revision 1.4  2003/10/22 18:06:36  gnowicki
 *  Changed comment size. Converted lat/lon to co-lat/lon (no - values allowed!).
 *
 *  Revision 1.3  2003/01/27 22:13:14  gnowicki
 *  Changed data_restraints structure, added support for byte array elems and
 *  removed depreciated data structures.
 *
 *
 */

#ifndef VINTRT_H
#define VINTRT_H

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

/*
 * user changeable defines
 */
#define BITS_PER_INT 32
#define SIZEOF_INT 4
/*
 * end of user changeable defines
 */

#define MAX_PARAMETERS 256
#define MAX_ASCII_SIZE 400
#define DEDICATED_ASCII_SIZE 160

#define COMMENT_SIZE MAX_ASCII_SIZE - DEDICATED_ASCII_SIZE

#define DATA_FORMAT_SIZE 4
#define MAX_VAR_NAME_SIZE 12
#define MAX_UNIT_NAME_SIZE 48
#define MAX_FILL_VALUES 3
#define MCIDAS_NAVARRAY_INTS 640
#define MCIDAS_HEADARRAY_INTS 64
/* edit this number in conjunction with number of items in full_list */
#define MAX_DATA_RESTRAINTS 26

struct visst_header {
  int data_format;
  int month, day, year, hour, minute, second;
  int nparams, nlines, npixels, mcidas_nsize, mcidas_hsize;
  int cmonth, cday, cyear, chour, cminute, csecond;
  float ul_lat, ul_lon, lr_lat, lr_lon;
  float x_res, y_res;
  char comment[COMMENT_SIZE];
};

struct data_restraints {
  int bits;    /* number of bits needed to hold this data value (including flag and neg bits) */
  int scale; /* scale of the data value (* input float value for sig digits */
  float min;   /* minimum value of the data (not scaled, not including flag values) */
  float max;   /* maximum value of the data (not scaled, not including flag values) */
  char var_name[MAX_VAR_NAME_SIZE];
  char unit_name[MAX_UNIT_NAME_SIZE];
};

struct var_attributes {
  char var_name[MAX_VAR_NAME_SIZE], unit_name[MAX_UNIT_NAME_SIZE];
  int min, max, num_fill, fill[MAX_FILL_VALUES];
  int data_format, var_num;
};

/*
 *  the first 22 are the new parameters in the correct order.
 */
/* Do Not Remove - For IDL  [Data Restraints Listing Begin] [Full] */
static const struct data_restraints full_list[] = {
/*                      bits    scale    min    max    var_name       unit_name  */
/*                                                     (11 char max) (47 char max) */
/*   0 Lat */   /*        15,      100,  -90.0,    90.0, "Lat",        "decimal degrees", */
/*   1 Lon */   /*        16,      100, -180.0,   180.0, "Lon",        "decimal degrees", */
/*   0 Lat */           16,      100,    0.0,   180.0, "Lat",        "decimal degrees",
/*   1 Lon */           17,      100,    0.0,   360.0, "Lon",        "decimal degrees",
/*   2 Vis(.65) refl */ 15,     1000,    0.0,     1.6, "Ref-.65",    "unitless",
/*   3 1.6 um refl */   15,     1000,    0.0,     1.6, "Ref-1.6",    "unitless",
/*   4 3.7 um temp */   17,      100,  160.0,   340.0, "T-3.7",      "kelvin",
/*   5 10.8 um temp */  17,      100,  160.0,   340.0, "T-10.8",     "kelvin",
/*   6 12 um temp */    17,      100,  160.0,   340.0, "T-12",       "kelvin",
/*   7 BBALB */         12,       10,    0.0,   150.0, "BBALB",      "percentage",
/*   8 BBOLR */         13,       10,    0.0,   400.0, "BBOLR",      "watts per square-meter",
/*   9 IR emit */       15,     1000,    0.0,     1.5, "IRemit",     "unitless",
/*  10 Mask */           5,        1,    0.0,     2.0, "Mask",       "unitless",
/*  11 Phase */          5,        1,    0.0,     8.0, "Phase",      "unitless",
/*  12 Tau */           15,      100,    0.0,   129.0, "Tau",        "unitless",
/*  13 Reff/Deff */     12,       10,    0.0,   150.0, "Reff-Deff",  "microns",
/*  14 LWP/IWP */       17,       10,    0.0,  6000.0, "LWP-IWP",    "grams per square-meter",
/*  15 Teff */          17,      100,  160.0,   340.0, "Teff",       "kelvin",
/*  16 Ptop */          15,       10,    0.0,  1100.0, "Ptop",       "millibars",
/*  17 Peff */          15,       10,    0.0,  1100.0, "Peff",       "millibars",
/*  18 Pbot */          15,       10,    0.0,  1100.0, "Pbot",       "millibars",
/*  19 Ztop */          12,      100,    0.0,    20.0, "Ztop",       "kilometers",
/*  20 Zeff */          12,      100,    0.0,    20.0, "Zeff",       "kilometers",
/*  21 Zbot */          12,      100,    0.0,    20.0, "Zbot",       "kilometers",
/*  22 Ch. 4-5 */       12,      100,   -8.0,    20.0, "T4-5",       "???",
/*  23 Region # */      11,        1,    0.0,   900.0, "Region",     "???",
/*  24 Ch. 3-4 */       14,      100,  -10.0,    60.0, "T3-4",       "???",
/*  25 DZ */            16,       10,    0.0,  2000.0, "CloudThick", "???",
/*  26 Ch 4 temp*/      13,       10,    0.0,   400.0, "T-4",        "???",
/*  27 place-01 */       5,        1,   -1.0,     2.0, "Place-01",   "unitless",
/*  28 place-02 */       5,        1,   -1.0,     2.0, "Place-02",   "unitless",
/*  29 place-03 */       5,        1,   -1.0,     2.0, "Place-03",   "unitless",
/*  30 place-04 */       5,        1,   -1.0,     2.0, "Place-04",   "unitless",
/*  31 place-05 */       5,        1,   -1.0,     2.0, "Place-05",   "unitless",
/*  32 place-06 */       5,        1,   -1.0,     2.0, "Place-06",   "unitless",
/*  33 place-07 */       5,        1,   -1.0,     2.0, "Place-07",   "unitless",
/*  34 place-08 */       5,        1,   -1.0,     2.0, "Place-08",   "unitless",
/*  35 place-09 */       5,        1,   -1.0,     2.0, "Place-09",   "unitless",
/*  36 place-10 */       5,        1,   -1.0,     2.0, "Place-10",   "unitless",
/*  37 place-11 */       5,        1,   -1.0,     2.0, "Place-11",   "unitless",
/*  38 place-12 */       5,        1,   -1.0,     2.0, "Place-12",   "unitless",
/*  39 place-13 */       5,        1,   -1.0,     2.0, "Place-13",   "unitless",
/*  40 place-14 */       5,        1,   -1.0,     2.0, "Place-14",   "unitless",
/*
 *  testing restraints
 */
/*  41 Test-01 */        5,        1,   -1.0,     2.0, "Test-01",    "units-01",
/*  42 Test-02 */        6,        1,    0.0,     1.0, "Test-02",    "units-02",
/*  43 Test-03 */        7,        1,    0.0,     2.0, "Test-03",    "units-03",
/*  44 Test-04 */        8,       10,    0.0,     3.0, "Test-04",    "units-04",
/*  45 Test-05 */        9,       10,    0.0,     4.0, "Test-05",    "units-05",
/*  46 Test-06 */       10,       10,    0.0,     5.0, "Test-06",    "units-06",
/*  47 Test-07 */       11,      100,    0.0,     6.0, "Test-07",    "units-07",
/*  48 Test-08 */       12,      100,    0.0,     7.0, "Test-08",    "units-08",
/*  49 Test-09 */       13,      100,    0.0,     8.0, "Test-09",    "units-09",
/*  50 Test-10 */       14,      100,    0.0,     9.0, "Test-10",    "units-10",
/*  51 Test-11 */       15,      100,  -22.0,     0.0, "Test-11",    "units-11",
/*  52 Test-12 */       16,      100,    0.0,   101.0, "Test-12",    "units-12",
/*  53 Test-13 */       17,     1000,    0.0,     4.5, "Test-13",    "units-13",
/*  54 Test-14 */       18,     1000,   -2.5,     0.0, "Test-14",    "units-14",
/*  55 Test-15 */       19,     1000,    0.0,    93.0, "Test-15",    "units-15",
/*  56 Test-16 */       20,     1000,   -2.0,     0.0, "Test-16",    "units-16",
/*  57 Test-17 */       21,     1000,   -3.0,     0.0, "Test-17",    "units-17",
/*  58 Test-18 */       22,     1000,   -4.0,     0.0, "Test-18",    "units-18",
/*  59 Test-19 */       23,     1000,   -5.0,     0.0, "Test-19",    "units-19",
/*  60 Test-20 */       24,     1000, -160.0,     0.0, "Test-20",    "units-20" };
/* Do Not Remove - For IDL  [Data Restraints Listing End] [Full] */

/* Do Not Remove - For IDL  [Data Order Listing Begin] [Order0] */
static const unsigned char order0[MAX_PARAMETERS] = {
   10,  12,  14,  20,  13,  11,   7,   8,  22,  23,
   15,  24,   9,  16,  25,   2,   0,   1,  26,  17,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255 };
/* Do Not Remove - For IDL  [Data Order Listing End] [Order0] */

/* Do Not Remove - For IDL  [Data Order Listing Begin] [Order1] */
static const unsigned char order1[MAX_PARAMETERS] = {
    0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  /*  0 -  9 */
   10,  11,  12,  13,  14,  15,  16,  17,  18,  19,  /* 10 - 19 */
   20,  21, 255, 255, 255, 255, 255, 255, 255, 255,  /* 20 - 29 */
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
  255, 255, 255, 255, 255, 255 };
/* Do Not Remove - For IDL  [Data Order Listing End] [Order1] */

static const unsigned int MASK[33] =
               { 0x00000000,
                 0x00000001, 0x00000003, 0x00000007, 0x0000000F,
                 0x0000001F, 0x0000003F, 0x0000007F, 0x000000FF,
                 0x000001FF, 0x000003FF, 0x000007FF, 0x00000FFF,
                 0x00001FFF, 0x00003FFF, 0x00007FFF, 0x0000FFFF,
                 0x0001FFFF, 0x0003FFFF, 0x0007FFFF, 0x000FFFFF,
                 0x001FFFFF, 0x0030FFFF, 0x007FFFFF, 0x00FFFFFF,
                 0x01FFFFFF, 0x03FFFFFF, 0x07FFFFFF, 0x0FFFFFFF,
                 0x1FFFFFFF, 0x3FFFFFFF, 0x7FFFFFFF, 0xFFFFFFFF };

/*
 *  just to be safe, PROTOTYPES!!!!
 */
/*
 *  vintrt utils - for external consumption.
 */
int vintrt_open(char *, int *, int *, int *);
int vintrt_open_(char *, int *, int *, int *);
int vintrt_var_attributes(const char *, char *, float [], float [], int *);
int vintrt_var_attributes_(const char *, char *, float [], float [], int *);
int vintrt_read_var(const char *, const int [], float []);
int vintrt_read_var_(const char *, const int [], float []);
int vintrt_get_header(char *);
int vintrt_get_header_(char *);
int vintrt_get_vname(int *, char *);
int vintrt_get_vname_(int *, char *);
int vintrt_get_datetime(int *, int *);
int vintrt_get_datetime_(int *, int *);
int vintrt_get_mcidas_size_(int *, int *);
int vintrt_get_mcidas_size(int *, int *);
int vintrt_close();
int vintrt_close_();
void vintrt_utils_version();
void vintrt_utils_version_();
/*
 *  for internal use
 */
struct visst_header *get_vintrt_head(const int *);
struct var_attributes *vintrt_var_attributes_old(const int *, const char *);
int packcp(const char *, const float *, const unsigned char *, const int *,
           const int *, const int *, const int *, const char *, const float *,
           const int *);
int packCP(const char *, const float *, const unsigned char *, const int *,
           const int *, const int *, const int *, const char *, const float *,
           const int *);
int packCP_(const char *, const float *, const unsigned char *, const int *,
            const int *, const int *, const int *, const char *, const float *,
            const int *);
int unpackcp(const char *, const int *, const int *, int *, int *, int *, float *,
             float *, char *);
int unpackCP(const char *, const int *, const int *, int *, int *, int *, float *,
             float *, char *);
int unpackCP_(const char *, const int *, const int *, int *, int *, int *, float *,
              float *, char *);

int CloudProducts(const char *, const int *, const int *, int *, float *,
                  float *, char *);
int CloudProducts_(const char *, const int *, const int *, int *, float *,
                   float *, char *);


/*
 *  structures for testing purposes only!
 */
#define TEST_PARAMETERS 20
#define TEST_ASCII_SIZE 300

static const float fill_values[TEST_PARAMETERS] = {
  -1., 1., 2., 3., 4.,
   5., 6., 7., 8., 9.,
  -22., 101., 4.5, -2.5, 93.,
   -2., -3., -4., -5., -160. };

#endif  /* #ifndef VINTRT_H */
