;load "$NCARG_ROOT/lib/ncarg/nclex/gsun/gsn_code.ncl"
;load "$NCARG_ROOT/lib/ncarg/nclex/gsun/gsn_csm.ncl"
load "/usr/local/lib/ncarg/nclex/gsun/gsn_code.ncl"
load "/usr/local/lib/ncarg/nclex/gsun/gsn_csm.ncl"

begin


; get the model hour 
modelhour = getenv("33")  ;
modelcycle = getenv("00")  ;
model     = getenv("GFS")  ;

print(modelcycle)  ;

xdate = systemfunc("date +%G%m%d") ;
;xdate = "20051006" ;
;xdate     = getenv("MDATE") 
print (xdate)  ;


  data_dir = ncargpath("data")
  ;grb_file = addfile("/data1.2/lunchrun/"+xdate+"/"+model+".t"+modelcycle+"z.pgrbf"+modelhour+".grb","r")
  ;grb_file = addfile("/home/Jacob05/grib/test/ens/gfs/geavg.t00z.pgrbaf06"+".grb","r")
  grb_file = addfile("/home/Jacob05/grib/test/ens/gfs/geavg.t00z.pgrbaf06.grb","r")

  lev = grb_file->lv_ISBL2
  print(lev) 
  print(grb_file)

  names = getfilevarnames(grb_file)  ; Get the variable names in the
  print(names) 
  atts = getfilevaratts(grb_file,names(0)) ; Get the variable attributes and
  dims = getfilevardims(grb_file,names(0)) ; dimension names from the GRIB
  print ("0-------------------------------0") ; 
  print(atts)                              ; file and print them out.
  print(dims)

  wks = gsn_open_wks("ps","/home/Jacob05/results/test_plot") ; Open an X11

     setvalues NhlGetWorkspaceObjectId()
     "wsMaximumSize": 334217728
     end setvalues

  gsn_define_colormap (wks,"WhViBlGrYeOrRe")    ; choose color map 

;----------- Begin first plot -----------------------------------------

  res             = True
  res@gsnMaximize = True 

  lat = grb_file->lat_3 ; 
  lon = grb_file->lon_3 ; 
  hgt = (/grb_file->HGT_3_ISBL(2,:,:)/) ; 
  hgt!0 = "lat" ; 
  hgt!1 = "lon" ; 

  itime  = (/grb_file->PRMSL_3_MSL@initial_time/)
  
  hgt&lat = lat  ; 
  hgt&lon = lon  ; 

print(lat)
print(lon)

  res@cnFillOn 		= True 
  res@cnLinesOn     	= False 
  res@gsnSpreadColors   = True
  res@cnInfoLabelOn     = False
  res@mpMinLatF         = -90            ; specify region to be plotted
  res@mpMaxLatF         = 90
  res@mpMinLonF         = 0
  res@mpMaxLonF         = 359

  ;res@vpXF              = 0.1                 	; make plot bigger
  ;res@vpYF              = 0.9         
  ;res@vpWidthF          = 0.8
  ;res@vpHeightF         = 0.8

  res@tiMainString = "500hPa Hgts(m)" + " Forecast " + modelhour + " hour" ;
  ;res@tiMainFont    = "Times-Roman"
  res@tiXAxisFuncCode = "~" ; 
  res@tiXAxisString = "Initialized at " + itime 
  res@tiMainFontHeightF = 0.02 
  res@tiXAxisFontHeightF = 0.01 

  res@cnLevelSpacingF   = 1000
  ;res@cnMaxLevelValF   = 101.6
  ;res@cnMinLevelValF   = 0
  ;res@lbLabelStride    = 4 

  ydate = systemfunc("date") ; 

  res@txString 		= ydate 
  res@txFontHeightF 	= .2 
  res@txPosXF 		 = 0.5 
  res@txPosYF 		 = 0.5 

  ;res@cnFillDrawOrder  = "Postdraw" 


  plot = gsn_csm_contour_map(wks,hgt,res)

  ;draw(ploth)
  ;frame(wks)

end
