#!/bin/bash
# Script: install.sh
# Author: Chad Herman
# Date: December 27, 2011
# Purpose: Installs the Gedit language specification files to enable
#          syntax highlighting of the NCAR Command Language.

usage()
{
	echo "$0: You must specify which major version of Gedit you are using!"
	echo "USAGE: $0 [2|3]"
	exit -1
}

# Check if only one argument was passed.
if [ $# -ne 1 ]; then
	usage
fi

# Only accept 2 and 3.
if [ $1 == 2 ]; then
	VER="2.0"
elif [ $1 == 3 ]; then
	VER="3.0"
else
	usage
fi

# Make sure the target directories exist before copying into them.
# Check the return codes so the script can die a peaceful death.
if [ ! -d ~/.local/share/gtksourceview-$VER/language-specs ]; then

	echo -ne "Making directory for nc.lang file ... "
	mkdir -p ~/.local/share/gtksourceview-$VER/language-specs
	if [ $? -ne 0 ]; then
		echo "Failed to create ~/.local/share/gtksourceview-$VER/language-specs"
		exit -1
	fi
	echo "Done."

fi

if [ ! -d ~/.local/share/mime/packages ]; then

	echo -ne "Making directory for nc.xml file ... "
	mkdir -p ~/.local/share/mime/packages
	if [ $? -ne 0 ]; then
		echo "Failed to create ~/.local/share/mime/packages"
		exit -1
	fi
	echo "Done!"

fi

# Copy the language specification and XML mime info files.
echo -ne "Copying nc.lang file ... "
cp ncl.lang ~/.local/share/gtksourceview-$VER/language-specs
if [ $? -ne 0 ]; then
	echo "Failed to copy ncl.lang"
	exit -1
fi
echo "Done!"

echo -ne "Copying nc.xml file ... "
cp ncl.xml ~/.local/share/mime/packages/
if [ $? -ne 0 ]; then
	echo "Failed to copy ncl.xml"
	exit -1
fi
echo "Done!"

# cd out into the directory containing the mime directory and
# update the mime database.
cd ~/.local/share
if [ $? -ne 0 ]; then
	echo "Failed to cd into ~/.local/share!"
	exit -1
fi

echo -ne "Updating mime database ... "
update-mime-database mime
if [ $? -ne 0 ]; then
	echo "Failed to update the mime database."
	exit -1
fi
echo "Done!"
