load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
begin

  inf      = "sst_initial.nc"   ; Initial sst(89,180)
  latlonfi = "latlon_Out.nc"        ; New lat(108) and lon(128) for interpolation , that is R42 grid
  outfi    = "sst_interpolation.nc" ; New interpolated sst(108,128)

;
; read in initial sst
;
  f   = addfile(inf,"r")     ; open initial sst data for reading
  sst = f->sst
  delete(f)
  ;printVarSummary(sst)       ; sst [lat | 89] x [lon | 180]
                              ; lat: [88..-88]
                              ; lon: [ 0..358]

;
; read in R43 lat and lon info
; 
  f   = addfile(latlonfi,"r")     ; open initial sst data for reading
  LAT = f->lat
  LON = f->lon
  delete(f)
  ;printVarSummary(LAT)       ; [lat | 108]; lat: [88.73005..-88.73004]
  ;printVarSummary(LON)       ; [lon | 128]; lon: [ 0..357.1875]

;
; interpolation
;
  sstNew = linint2_Wrap (sst&lon,sst&lat,sst, False, LON,LAT, 0)
  printVarSummary(sstNew)

;
; output nc
;
  system ("rm "+outfi)             ; remove any pre-existing file
  ncdf   = addfile(outfi,"c")      ; create new netCDF file
  ncdf->sstNew =  sstNew

  print(sstNew({0},{190:230}))     ; All missing data!
                                   ; However, SSTs over Topical Easten Pacific shouldn't be missing value!
end
