load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin

  station_data_file = "best_station_data_198501.nc"

; Open the station data file.
  f = addfile(station_data_file, "r")

; Load the grid coordinates and the surface temperature data.
  lat_in = f->lat
  lon_in = f->lon
  tas_in = f->tas

; Define the grid to interpolate to.
  num_lat_out = 72
  num_lon_out = 144

  num_lat_out@double = True
  num_lon_out@double = True

  lat_out = latGlobeFo(num_lat_out, "lat", "Latitude", "degrees_north")
  lon_out = lonGlobeFo(num_lon_out, "lon", "Longitude", "degrees_east")
  lon_out = lon_out - 180.d

; "Interpolate" with bin_avg.
  tmp = bin_avg(lon_in, lat_in, tas_in, lon_out, lat_out, False)
  tas_out_bin_avg = tmp(0,:,:)
  delete(tmp)

  tas_out_bin_avg!0 = "lat"
  tas_out_bin_avg!1 = "lon"

  tas_out_bin_avg&lat = lat_out
  tas_out_bin_avg&lon = lon_out

  tas_out_bin_avg@_FillValue = tas_in@_FillValue

; "Interpolate" with triple2grid.
  tas_out_triple2grid = triple2grid(lon_in, lat_in, tas_in, lon_out, lat_out, False)
  tas_out_triple2grid!0 = "lat"
  tas_out_triple2grid!1 = "lon"

  tas_out_triple2grid&lat = lat_out
  tas_out_triple2grid&lon = lon_out

; Now plot the results side-by-side. Notice a shift?

  res                       = True
  res@gsnDraw               = False
  res@gsnFrame              = False
  res@cnFillOn              = True
  res@cnLinesOn             = False
  res@lbLabelBarOn          = False
  res@cnFillMode            = "CellFill"
  res@cnLevelSelectionMode  = "ManualLevels"
  res@cnMinLevelValF        = -40
  res@cnMaxLevelValF        = 40              
  res@cnLevelSpacingF       = 5
  res@gsnMaximize           = True
  res@cnMissingValFillColor = "gray"
  res@gsnSpreadColors       = True
  res@gsnSpreadColorEnd     = -2
  res@mpProjection          = "Mollweide"

  output_file = "interp_bug.png"

  wks_type          = "png"
  wks_type@wkWidth  = 1024*2
  wks_type@wkHeight = 1024*2

  wks = gsn_open_wks (wks_type, "temp.png")
  gsn_define_colormap(wks,"BlueRedGray")
  plot = new(2, graphic)

  res@tiMainString = "bin_avg"
  plot(0) = gsn_csm_contour_map(wks, tas_out_bin_avg, res)

  res@tiMainString = "triple2grid"
  plot(1) = gsn_csm_contour_map(wks, tas_out_triple2grid, res)

  resP                    = True
  resP@txString           = "Different interpolation results?"
  resP@gsnPanelLabelBar   = True
  resP@lbLabelFontHeightF = 0.007
  gsn_panel(wks, plot, (/1,2/), resP)

  system("convert -trim temp.png " + output_file)
  system("rm -f temp.png")

end