;----------------------------------------------------------------------
; This script creates a filled contour plot of temperature on a
; CAM-SE grid over a Robinson map projection.
; 
; This script is identical to camse_3.ncl, except additional
; options are set to change the map projection, increase the number
; of contour levels, and add map lat/lon lines. Also, a different
; color map is used.
;
; The CAM-SE grid is unstructured, which means you have 
; one-dimensional arrays of the same length containing the
; data and the lat/lon coordinates.
;
; Only minimal plotting options are set in this script.
;----------------------------------------------------------------------
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

;----------------------------------------------------------------------
; This function returns the RGB triples for a GMT color map, "seis".
; This color map goes from red to blue, and we want blue to red, so
; we reverse it before returning it.
;----------------------------------------------------------------------
function colormap()
begin
  cmap = (/(/0.672506, 0.000000, 0.000000/), \
           (/0.684183, 0.000000, 0.000000/), \
           (/0.695861, 0.000000, 0.000000/), \
           (/0.707539, 0.000000, 0.000000/), \
           (/0.719217, 0.000000, 0.000000/), \
           (/0.730895, 0.000000, 0.000000/), \
           (/0.742573, 0.000000, 0.000000/), \
           (/0.754251, 0.000000, 0.000000/), \
           (/0.765929, 0.000000, 0.000000/), \
           (/0.777607, 0.000000, 0.000000/), \
           (/0.789284, 0.000000, 0.000000/), \
           (/0.800962, 0.000000, 0.000000/), \
           (/0.812640, 0.000000, 0.000000/), \
           (/0.824318, 0.000000, 0.000000/), \
           (/0.835996, 0.000000, 0.000000/), \
           (/0.847674, 0.000000, 0.000000/), \
           (/0.859352, 0.000000, 0.000000/), \
           (/0.871030, 0.000000, 0.000000/), \
           (/0.882707, 0.000000, 0.000000/), \
           (/0.894385, 0.000000, 0.000000/), \
           (/0.906063, 0.000000, 0.000000/), \
           (/0.917741, 0.000000, 0.000000/), \
           (/0.929419, 0.000000, 0.000000/), \
           (/0.941097, 0.000000, 0.000000/), \
           (/0.952775, 0.000000, 0.000000/), \
           (/0.964453, 0.000000, 0.000000/), \
           (/0.976130, 0.000000, 0.000000/), \
           (/0.987808, 0.000000, 0.000000/), \
           (/0.999486, 0.000000, 0.000000/), \
           (/1.000000, 0.011214, 0.000000/), \
           (/1.000000, 0.022945, 0.000000/), \
           (/1.000000, 0.034675, 0.000000/), \
           (/1.000000, 0.046406, 0.000000/), \
           (/1.000000, 0.058136, 0.000000/), \
           (/1.000000, 0.069867, 0.000000/), \
           (/1.000000, 0.081597, 0.000000/), \
           (/1.000000, 0.093328, 0.000000/), \
           (/1.000000, 0.105058, 0.000000/), \
           (/1.000000, 0.116789, 0.000000/), \
           (/1.000000, 0.128519, 0.000000/), \
           (/1.000000, 0.140250, 0.000000/), \
           (/1.000000, 0.151980, 0.000000/), \
           (/1.000000, 0.163711, 0.000000/), \
           (/1.000000, 0.175441, 0.000000/), \
           (/1.000000, 0.187172, 0.000000/), \
           (/1.000000, 0.198902, 0.000000/), \
           (/1.000000, 0.210633, 0.000000/), \
           (/1.000000, 0.222363, 0.000000/), \
           (/1.000000, 0.234093, 0.000000/), \
           (/1.000000, 0.245824, 0.000000/), \
           (/1.000000, 0.257554, 0.000000/), \
           (/1.000000, 0.269285, 0.000000/), \
           (/1.000000, 0.281015, 0.000000/), \
           (/1.000000, 0.292746, 0.000000/), \
           (/1.000000, 0.304476, 0.000000/), \
           (/1.000000, 0.316207, 0.000000/), \
           (/1.000000, 0.327937, 0.000000/), \
           (/1.000000, 0.339668, 0.000000/), \
           (/1.000000, 0.351398, 0.000000/), \
           (/1.000000, 0.363129, 0.000000/), \
           (/1.000000, 0.374859, 0.000000/), \
           (/1.000000, 0.386590, 0.000000/), \
           (/1.000000, 0.398320, 0.000000/), \
           (/1.000000, 0.410051, 0.000000/), \
           (/1.000000, 0.421781, 0.000000/), \
           (/1.000000, 0.433512, 0.000000/), \
           (/1.000000, 0.445242, 0.000000/), \
           (/1.000000, 0.456973, 0.000000/), \
           (/1.000000, 0.468703, 0.000000/), \
           (/1.000000, 0.480434, 0.000000/), \
           (/1.000000, 0.492164, 0.000000/), \
           (/1.000000, 0.503895, 0.000000/), \
           (/1.000000, 0.515625, 0.000000/), \
           (/1.000000, 0.527355, 0.000000/), \
           (/1.000000, 0.539086, 0.000000/), \
           (/1.000000, 0.550816, 0.000000/), \
           (/1.000000, 0.562547, 0.000000/), \
           (/1.000000, 0.574277, 0.000000/), \
           (/1.000000, 0.586008, 0.000000/), \
           (/1.000000, 0.597738, 0.000000/), \
           (/1.000000, 0.609469, 0.000000/), \
           (/1.000000, 0.621199, 0.000000/), \
           (/1.000000, 0.632930, 0.000000/), \
           (/1.000000, 0.644660, 0.000000/), \
           (/1.000000, 0.656391, 0.000000/), \
           (/1.000000, 0.668121, 0.000000/), \
           (/1.000000, 0.679852, 0.000000/), \
           (/1.000000, 0.691582, 0.000000/), \
           (/1.000000, 0.703313, 0.000000/), \
           (/1.000000, 0.715043, 0.000000/), \
           (/1.000000, 0.726774, 0.000000/), \
           (/1.000000, 0.738504, 0.000000/), \
           (/1.000000, 0.750235, 0.000000/), \
           (/1.000000, 0.761965, 0.000000/), \
           (/1.000000, 0.773696, 0.000000/), \
           (/1.000000, 0.785426, 0.000000/), \
           (/1.000000, 0.797157, 0.000000/), \
           (/1.000000, 0.808887, 0.000000/), \
           (/1.000000, 0.820617, 0.000000/), \
           (/1.000000, 0.832348, 0.000000/), \
           (/1.000000, 0.844078, 0.000000/), \
           (/1.000000, 0.855809, 0.000000/), \
           (/1.000000, 0.867539, 0.000000/), \
           (/1.000000, 0.879270, 0.000000/), \
           (/1.000000, 0.891000, 0.000000/), \
           (/1.000000, 0.902731, 0.000000/), \
           (/1.000000, 0.914461, 0.000000/), \
           (/1.000000, 0.926192, 0.000000/), \
           (/1.000000, 0.937922, 0.000000/), \
           (/1.000000, 0.949653, 0.000000/), \
           (/1.000000, 0.961383, 0.000000/), \
           (/1.000000, 0.973114, 0.000000/), \
           (/1.000000, 0.984844, 0.000000/), \
           (/1.000000, 0.996575, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/1.000000, 1.000000, 0.000000/), \
           (/0.993351, 1.000000, 0.001209/), \
           (/0.970580, 1.000000, 0.005349/), \
           (/0.947809, 1.000000, 0.009489/), \
           (/0.925038, 1.000000, 0.013629/), \
           (/0.902267, 1.000000, 0.017770/), \
           (/0.879496, 1.000000, 0.021910/), \
           (/0.856725, 1.000000, 0.026050/), \
           (/0.833954, 1.000000, 0.030190/), \
           (/0.811183, 1.000000, 0.034330/), \
           (/0.788412, 1.000000, 0.038470/), \
           (/0.765642, 1.000000, 0.042611/), \
           (/0.742871, 1.000000, 0.046751/), \
           (/0.720100, 1.000000, 0.050891/), \
           (/0.697329, 1.000000, 0.055031/), \
           (/0.674558, 1.000000, 0.059171/), \
           (/0.651787, 1.000000, 0.063311/), \
           (/0.629016, 1.000000, 0.067452/), \
           (/0.606245, 1.000000, 0.071592/), \
           (/0.583474, 1.000000, 0.075732/), \
           (/0.560703, 1.000000, 0.079872/), \
           (/0.537932, 1.000000, 0.084012/), \
           (/0.515161, 1.000000, 0.088152/), \
           (/0.492390, 1.000000, 0.092293/), \
           (/0.469619, 1.000000, 0.096433/), \
           (/0.446849, 1.000000, 0.100573/), \
           (/0.424078, 1.000000, 0.104713/), \
           (/0.401307, 1.000000, 0.108853/), \
           (/0.378536, 1.000000, 0.112994/), \
           (/0.355765, 1.000000, 0.117134/), \
           (/0.342061, 0.998187, 0.127318/), \
           (/0.329640, 0.996117, 0.138359/), \
           (/0.317220, 0.994046, 0.149399/), \
           (/0.304799, 0.991976, 0.160440/), \
           (/0.292379, 0.989906, 0.171480/), \
           (/0.279958, 0.987836, 0.182521/), \
           (/0.267538, 0.985766, 0.193561/), \
           (/0.255117, 0.983696, 0.204602/), \
           (/0.242697, 0.981626, 0.215642/), \
           (/0.230276, 0.979556, 0.226683/), \
           (/0.217856, 0.977486, 0.237723/), \
           (/0.205435, 0.975416, 0.248763/), \
           (/0.193015, 0.973346, 0.259804/), \
           (/0.180594, 0.971276, 0.270844/), \
           (/0.168174, 0.969205, 0.281885/), \
           (/0.155753, 0.967135, 0.292925/), \
           (/0.143333, 0.965065, 0.303966/), \
           (/0.130912, 0.962995, 0.315006/), \
           (/0.118492, 0.960925, 0.326047/), \
           (/0.106071, 0.958855, 0.337087/), \
           (/0.093651, 0.956785, 0.348128/), \
           (/0.081230, 0.954715, 0.359168/), \
           (/0.068810, 0.952645, 0.370208/), \
           (/0.056389, 0.950575, 0.381249/), \
           (/0.043969, 0.948505, 0.392289/), \
           (/0.031548, 0.946434, 0.403330/), \
           (/0.019128, 0.944364, 0.414370/), \
           (/0.006707, 0.942294, 0.425411/), \
           (/0.000000, 0.931019, 0.440578/), \
           (/0.000000, 0.908938, 0.460588/), \
           (/0.000000, 0.886857, 0.480599/), \
           (/0.000000, 0.864777, 0.500610/), \
           (/0.000000, 0.842696, 0.520621/), \
           (/0.000000, 0.820615, 0.540632/), \
           (/0.000000, 0.798534, 0.560642/), \
           (/0.000000, 0.776453, 0.580653/), \
           (/0.000000, 0.754372, 0.600664/), \
           (/0.000000, 0.732291, 0.620675/), \
           (/0.000000, 0.710210, 0.640686/), \
           (/0.000000, 0.688129, 0.660697/), \
           (/0.000000, 0.666048, 0.680707/), \
           (/0.000000, 0.643967, 0.700718/), \
           (/0.000000, 0.621887, 0.720729/), \
           (/0.000000, 0.599806, 0.740740/), \
           (/0.000000, 0.577725, 0.760751/), \
           (/0.000000, 0.555644, 0.780761/), \
           (/0.000000, 0.533563, 0.800772/), \
           (/0.000000, 0.511482, 0.820783/), \
           (/0.000000, 0.489401, 0.840794/), \
           (/0.000000, 0.467320, 0.860805/), \
           (/0.000000, 0.445239, 0.880816/), \
           (/0.000000, 0.423158, 0.900826/), \
           (/0.000000, 0.401078, 0.920837/), \
           (/0.000000, 0.378997, 0.940848/), \
           (/0.000000, 0.356916, 0.960859/), \
           (/0.000000, 0.334835, 0.980870/), \
           (/0.000000, 0.313242, 0.999698/), \
           (/0.000000, 0.302251, 0.992828/), \
           (/0.000000, 0.291260, 0.985959/), \
           (/0.000000, 0.280269, 0.979090/), \
           (/0.000000, 0.269278, 0.972220/), \
           (/0.000000, 0.258287, 0.965351/), \
           (/0.000000, 0.247296, 0.958482/), \
           (/0.000000, 0.236305, 0.951612/), \
           (/0.000000, 0.225314, 0.944743/), \
           (/0.000000, 0.214323, 0.937874/), \
           (/0.000000, 0.203332, 0.931004/), \
           (/0.000000, 0.192342, 0.924135/), \
           (/0.000000, 0.181351, 0.917266/), \
           (/0.000000, 0.170360, 0.910396/), \
           (/0.000000, 0.159369, 0.903527/), \
           (/0.000000, 0.148378, 0.896658/), \
           (/0.000000, 0.137387, 0.889788/), \
           (/0.000000, 0.126396, 0.882919/), \
           (/0.000000, 0.115405, 0.876050/), \
           (/0.000000, 0.104414, 0.869180/), \
           (/0.000000, 0.093423, 0.862311/), \
           (/0.000000, 0.082432, 0.855442/), \
           (/0.000000, 0.071441, 0.848572/), \
           (/0.000000, 0.060450, 0.841703/), \
           (/0.000000, 0.049459, 0.834834/), \
           (/0.000000, 0.038468, 0.827964/), \
           (/0.000000, 0.027477, 0.821095/), \
           (/0.000000, 0.016486, 0.814226/), \
           (/0.000000, 0.005495, 0.807356/)/)
  return(cmap(::-1,:))
end

;----------------------------------------------------------------------
; Main code
;----------------------------------------------------------------------
begin
    filename = "b1850cam5cn_camse_01_climo_subset.nc"
    f        = addfile(filename,"r")
    t850     = f->T850                     ; ncol
    lon1d    = f->lon
    lat1d    = f->lat

;   printMinMax(t850,0)
;   printMinMax(lat1d,0)
;   printMinMax(lon1d,0)

;----------------------------------------------------------------------
; Plotting section
;----------------------------------------------------------------------
    wks = gsn_open_wks("png","camse_4")

;---Variable to hold plot options
    res                       = True

;---Maximize plot in frame
    res@gsnMaximize           = True

;---Change the map projection
    res@mpProjection          = "Robinson"
    res@mpPerimOn             = False         ; Turn off perimeter

;---Color contour fill using raster contours
    res@cnFillOn              = True
    res@cnFillMode            = "RasterFill"
    res@cnFillPalette         = colormap()

;---Lines and labels off
    res@cnLinesOn             = False
    res@cnLineLabelsOn        = False

;---Contour levels
    res@cnLevelSelectionMode  = "ManualLevels"
    res@cnMinLevelValF        = 240
    res@cnMaxLevelValF        = 296
    res@cnLevelSpacingF       =   1
     
;---Lat/lon arrays for overlaying on map
    res@sfXArray              = lon1d
    res@sfYArray              = lat1d

;---Main title
    res@tiMainString = "CAM-SE grid (" + dimsizes(t850) + " cells)"

    plot = gsn_csm_contour_map(wks,t850,res)
end
