;----------------------------------------------------------------------
; This script creates a line contour plot of temperature on a
; CAM-SE grid.
; 
; Only minimal plotting options are set in this script.
;
; The CAM-SE grid is unstructured, which means you have 
; one-dimensional arrays of the same length containing the
; data and the lat/lon coordinates.
;----------------------------------------------------------------------
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin
;---Open file and read temperature, lat, lon arrays.
    filename = "b1850cam5cn_camse_01_climo_subset.nc"
    f        = addfile(filename,"r")
    t850     = f->T850                     ; ncol
    lon1d    = f->lon
    lat1d    = f->lat

;----------------------------------------------------------------------
; Plotting section
;----------------------------------------------------------------------
    wks = gsn_open_wks("png","camse_1")

;---Variable to hold plot options
    res                       = True

;---Maximize plot in frame
    res@gsnMaximize           = True

;---Lat/lon arrays for overlaying on map
    res@sfXArray              = lon1d
    res@sfYArray              = lat1d

    plot = gsn_csm_contour_map(wks,t850,res)
end
