;----------------------------------------------------------------------
; This script creates a filled contour plot of temperature on a
; CAM-SE grid, using raster contours. This can be faster than
; using default "area" fill contours.
; 
; This script is identical to camse_2.ncl, except additional
; options are set to use raster contours, change the color map used,
; and change the contour levels.
;
; The CAM-SE grid is unstructured, which means you have 
; one-dimensional arrays of the same length containing the
; data and the lat/lon coordinates.
;
; Only minimal plotting options are set in this script.
;----------------------------------------------------------------------
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"

begin
;---Open file and read temperature, lat, lon arrays.
    filename = "b1850cam5cn_camse_01_climo_subset.nc"
    f        = addfile(filename,"r")
    t850     = f->T850                     ; ncol
    lon1d    = f->lon
    lat1d    = f->lat

;   printMinMax(t850,0)
;   printMinMax(lat1d,0)
;   printMinMax(lon1d,0)

;----------------------------------------------------------------------
; Plotting section
;----------------------------------------------------------------------
    wks = gsn_open_wks("png","camse_3")

;---Variable to hold plot options
    res                       = True

;---Maximize plot in frame
    res@gsnMaximize           = True

;---Color contour fill using raster contours
    res@cnFillOn              = True
    res@cnFillMode            = "RasterFill"
    res@cnFillPalette         = "WhiteBlueGreenYellowRed"

;---Lines and labels off
    res@cnLinesOn             = False
    res@cnLineLabelsOn        = False

;---Contour levels
    res@cnLevelSelectionMode  = "ManualLevels"
    res@cnMinLevelValF        = 240
    res@cnMaxLevelValF        = 296
    res@cnLevelSpacingF       =   2
     
;---Lat/lon arrays for overlaying on map
    res@sfXArray              = lon1d
    res@sfYArray              = lat1d

;---Main title
    res@tiMainString = "Raster contours - CAM-SE grid (" + dimsizes(t850) + " cells)"

    plot = gsn_csm_contour_map(wks,t850,res)
end
