;----------------------------------------------------------------------
; This script creates a color contour plot of temperature on a
; NEMO grid.
;
; This script is identical to nemo_2.ncl, except additional
; options are set to use better map resolution, and fill the
; ocean and land in different colors.
;
; The NEMO grid is curvilinear, which means you have two-dimensional
; lat/lon arrays of the same size as the data array.
;----------------------------------------------------------------------
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"   

begin
;---Open file and read temperature, lat, lon arrays.
  filename = "CNTASN_1m_200103_grid_T.nc"
  f        = addfile (filename, "r")
  v        = f->votemper            ; (time_counter, deptht, y, x) 
  lat2d    = f->nav_lat             ; (y,x)
  lon2d    = f->nav_lon             ; (y,x)
  nt       = 0                      ; time index to plot
  nd       = 0                      ; depth index to plot

;---Convert "time" coordinate array to different units
  date = cd_calendar(v&time_counter, -3)   ; YYYYMMDDHH

;----------------------------------------------------------------------
; Plotting section
;----------------------------------------------------------------------
  wks = gsn_open_wks("png","nemo_3")

;---Set some resources
  res                 = True

;---Maximize plot in frame
  res@gsnMaximize     = True

  res@cnFillOn        = True          ; Turn on contour fill
  res@cnFillPalette   = "BlAqGrYeOrReVi200"

  res@cnLinesOn       = False         ; Turn off contour lines
  res@cnLevelSpacingF = 0.5           ; Change contour level spacing

;---Use better map outlines and set fill colors
  res@mpDataBaseVersion      = "MediumRes"
  res@mpLandFillColor        = "tan"
  res@mpOceanFillColor       = "LightBlue"
  res@mpInlandWaterFillColor = "LightBlue"

;---Zoom in on map
  res@mpMinLatF       = min(lat2d)
  res@mpMaxLatF       = max(lat2d)
  res@mpMinLonF       = min(lon2d)
  res@mpMaxLonF       = max(lon2d)

;---Lat/lon arrays for overlaying on map
  res@sfXArray        = lon2d
  res@sfYArray        = lat2d

  res@gsnAddCyclic    = False      ; Data not global, don't add lon cyclic pt

  res@tiMainString = filename + " [" + date(nt) + "  z=" + v&deptht(nd) + "]"

  plot = gsn_csm_contour_map(wks,v(nt,nd,:,:),res)

end
