;----------------------------------------------------------------------
; This script creates a vector plot of divergent winds. NCL has
; built-in spherical harmonics routines for doing these kind of
; calculations.
;
; This script is identical to uv300_wind_1.ncl, except additional
; options are set to create curly vectors.
;
; The u and v read off the file have lat/lon coordinate arrays 
; attached, so they don't have to be read off the file.
;----------------------------------------------------------------------
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"    
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl" 

begin
;---Open NetCDF file and read in u and v
  f    = addfile ("uv300.nc", "r")
  u    = f->U
  v    = f->V

;---Calculate divergence. The "xxx_Wrap" functions include metadata
  div = uv2dvG_Wrap(u,v)                ; u,v ==> divergence

;---Calculate divergent wind components 
  uvd = dv2uvG_Wrap(div)      ; uvd(0,:,:,:) ==> u, uvd(1,:,:,:) ==> v

;----------------------------------------------------------------------
; Plotting section
;----------------------------------------------------------------------
  wks  = gsn_open_wks("png","uv300_wind_2")
                                             
  res                 = True

  res@gsnMaximize     = True          ; maximize plot in frame
  res@vcRefMagnitudeF = 3.            ; make vectors larger
  res@vcRefLengthF    = 0.050         ; reference vector length
  res@vcMinDistanceF  = 0.012         ; thin the vectors
  res@vcGlyphStyle    = "CurlyVector" ; turn on curly vectors

  res@gsnLeftString   = "Divergent Wind"
                                              ; plot 1st time step
  plot = gsn_csm_vector_map(wks,uvd(0,0,:,:),uvd(1,0,:,:),res)

end

