;----------------------------------------------------------------------
; This script creates a vector plot of rotational winds. NCL has
; built-in spherical harmonics routines for doing these kind of
; calculations.
;
; The u and v read off the file have lat/lon coordinate arrays 
; attached, so they don't have to be read off the file.
;----------------------------------------------------------------------
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"    
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl" 

begin
;---Open NetCDF file and read in u and v
  f    = addfile ("uv300.nc", "r")
  u    = f->U
  v    = f->V

;---Calculate vorticity. The "xxx_Wrap" functions include metadata
  vrt = uv2vrG_Wrap(u,v)         

;---Calculate rotational wind component 
  uvr = vr2uvG_Wrap(vrt)

;----------------------------------------------------------------------
; Plotting section
;----------------------------------------------------------------------
  wks  = gsn_open_wks("png","uv300_wind_3")
                                             
  res                 = True

  res@gsnMaximize     = True          ; maximize plot in frame
  res@vcRefMagnitudeF = 3.            ; make vectors larger
  res@vcRefLengthF    = 0.050         ; reference vector length
  res@vcMinDistanceF  = 0.012         ; thin the vectors
  res@vcGlyphStyle    = "CurlyVector" ; turn on curly vectors

  res@gsnLeftString   = "Meridional Rotational Wind"
                                              ; plot 1st time step
  plot = gsn_csm_vector_map(wks,uvr(0,0,:,:),uvr(1,0,:,:),res)

end

