;----------------------------------------------------------------------
; This script draws divergent wind vectors over a filled contour plot
; of velocity potential.
;----------------------------------------------------------------------
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"   
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"    
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl" 

begin
;---Open NetCDF file and read in u and v
  f = addfile ("uv300.nc", "r")
  u = f->U                           ; (time,lat,lon)
  v = f->V

;---Calculate divergence on a gaussian grid
  div = uv2dvG_Wrap(u,v)                ; u,v ==> divergence

;---Calculate velocity potential
  chi = ilapsG_Wrap ( div , 0)
  chi = (/chi/1e6/)                     ; arbitrary scale
  chi@long_name = "velocity potential"
  chi@units     = "m/s" 

;---Calculate divergent wind component 
  uvd = dv2uvG_Wrap(div)

;----------------------------------------------------------------------
; Plotting section
;----------------------------------------------------------------------
  wks  = gsn_open_wks("png","uv300_wind_4")

;---Contour resources
  cnres                      = True

  cnres@gsnDraw              = False       ; dont'
  cnres@gsnFrame             = False
  cnres@gsnMaximize          = True

  cnres@cnFillOn             = True               ; color on
  cnres@cnLinesOn            = False              ; turn off contour lines
  cnres@cnFillPalette        = "BlAqGrYeOrReVi200"

  cnres@tiMainString         = "Velocity Potential via Spherical Harmonics"
  cnres@gsnCenterString      = "Chi scaled by 1e6"
  cnres@gsnLeftString        = "Divergent Wind"

;---Vector resources
  vcres                      = True
  vcres@gsnDraw              = False
  vcres@gsnFrame             = False

  vcres@vcRefMagnitudeF      = 3.                 ; make vectors larger
  vcres@vcRefLengthF         = 0.050              ; ref vector length
  vcres@vcGlyphStyle         = "CurlyVector"      ; turn on curly vectors
  vcres@vcMinDistanceF       = 0.012              ; thin the vectors
  vcres@vcRefAnnoOrthogonalPosF  = -0.52           ; Move ref anno into plot
  vcres@gsnCenterString          = ""
  vcres@gsnLeftString            = ""

;----------------------------------------------------------------------
; To overlay multiple plots (vectors on contours on a map), create a
; contour/map plot and a vector plot, and then use the "overlay"
; procedure to overlay the vector plot on the contour/map plot.
;----------------------------------------------------------------------
  contour = gsn_csm_contour_map(wks,chi(0,:,:),cnres)
  vector  = gsn_csm_vector(wks,uvd(0,0,:,:),uvd(1,0,:,:),vcres)

  overlay(contour,vector)
  draw(contour)                ; This will draw the vectors too
  frame(wks)
end

