;----------------------------------------------------------------------
; This script creates a line contour plot of zonal winds on a simple
; rectilinear grid. No plotting options are set in this script.
;
; Rectilinear grids are those that can be represented by one-dimensional
; coordinate arrays. A coordinate array is the same length as the 
; axis it represents. For example, if you have a data variable that
; is dimensioned 64 x 128, then the latitude array will be 64
; elements, and the longitude array 128 elements.
; 
; With NCL, you can verify if your variable has coordinate arrays by
; using the "printVarSummary" procedure. The output from this 
; procedure will tell you if you have coordinate arrays.
;----------------------------------------------------------------------
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  

begin
;---Open NetCDF file and read in July zonal winds
  a = addfile("uv300.nc","r")
  u = a->U(1,:,:)
  printVarSummary(u)

;----------------------------------------------------------------------
; Plotting section - default contour/map plot
;
; Note that you don't have to read lat/lon off the file. They are
; attached to the "u" variable that we read in, and are
; automatically recognized and used by the gsn_csm_contour_map
; function.
;----------------------------------------------------------------------
  wks = gsn_open_wks("png","uv300_1")
  plot = gsn_csm_contour_map(wks,u,False)
end



