; NCL file created by ./ctl2ncl

; Longitude co-ordinate
; ................
  nlon=144
  lon=fspan(0.0,357.5,144)
  lon!0="lon"
  lon&lon=lon
  lon@units="degrees east"
  lon@long_name="Longitude"
  printVarSummary(lon)

; Latitude co-ordinate
; ................
  nlat=73
  lat=fspan(-90.0,90.0,73)
  lat!0="lat"
  lat&lat=lat
  lat@units="degrees north"
  lat@long_name="Latitude"
  printVarSummary(lat)

; Z co-ordinate
; ................
  nlev=6
  lev=fspan(1.0,6.0,6)
  lev!0="lev"
  lev&lev=lev
  lev@units="unknown"
  lev@long_name="z-levels"
  printVarSummary(lev)

; T co-ordinate
; ................
  ntim=6
  time=fspan(0.5,5.5,ntim)
  time!0="time"
  time&time=time
  time@units="months since 1983-11-1 0:0"
  time@long_name="time"
  printVarSummary(time)

; Open the binary data file
  setfileoption("bin","ReadByteOrder","LittleEndian")
  path="//home/saji/Grad2NCL/SUT1/SUT1.M11.2007.GDAT"
  rec_dims=(/nlat,nlon/)
  rec_type="float"

      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=6      
  sst=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
  rec_num=it*60
  rec_num=rec_num+0
    do il=0,nens-1
      sst(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  sst@units="C"      
  sst@long_name="surface temperature"      
  sst!0="time"
  sst!1="lev"
  sst!2="lat"
  sst!3="lon"
  sst&lon=lon
  sst&lat=lat
  sst&lev=lev
  sst&time=tim2
  sst@_FillValue=9.999e+20
  sst@missing_value=9.999e+20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=6      
  prcp=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
  rec_num=it*60
  rec_num=rec_num+6
    do il=0,nens-1
      prcp(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  prcp@units="mm/day"      
  prcp@long_name="total precipitation"      
  prcp!0="time"
  prcp!1="lev"
  prcp!2="lat"
  prcp!3="lon"
  prcp&lon=lon
  prcp&lat=lat
  prcp&lev=lev
  prcp&time=tim2
  prcp@_FillValue=9.999e+20
  prcp@missing_value=9.999e+20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=6      
  mslp=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
  rec_num=it*60
  rec_num=rec_num+12
    do il=0,nens-1
      mslp(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  mslp@units="hPa"      
  mslp@long_name="mean sea level pressure"      
  mslp!0="time"
  mslp!1="lev"
  mslp!2="lat"
  mslp!3="lon"
  mslp&lon=lon
  mslp&lat=lat
  mslp&lev=lev
  mslp&time=tim2
  mslp@_FillValue=9.999e+20
  mslp@missing_value=9.999e+20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=6      
  ts2m=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
  rec_num=it*60
  rec_num=rec_num+18
    do il=0,nens-1
      ts2m(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  ts2m@units="C"      
  ts2m@long_name="9 99 2m air temperature"      
  ts2m!0="time"
  ts2m!1="lev"
  ts2m!2="lat"
  ts2m!3="lon"
  ts2m&lon=lon
  ts2m&lat=lat
  ts2m&lev=lev
  ts2m&time=tim2
  ts2m@_FillValue=9.999e+20
  ts2m@missing_value=9.999e+20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=6      
  t850=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
  rec_num=it*60
  rec_num=rec_num+24
    do il=0,nens-1
      t850(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  t850@units="C"      
  t850@long_name="temperature at 850hPa"      
  t850!0="time"
  t850!1="lev"
  t850!2="lat"
  t850!3="lon"
  t850&lon=lon
  t850&lat=lat
  t850&lev=lev
  t850&time=tim2
  t850@_FillValue=9.999e+20
  t850@missing_value=9.999e+20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=6      
  z500=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
  rec_num=it*60
  rec_num=rec_num+30
    do il=0,nens-1
      z500(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  z500@units="gpm"      
  z500@long_name="goopotential height at 500hPa"      
  z500!0="time"
  z500!1="lev"
  z500!2="lat"
  z500!3="lon"
  z500&lon=lon
  z500&lat=lat
  z500&lev=lev
  z500&time=tim2
  z500@_FillValue=9.999e+20
  z500@missing_value=9.999e+20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=6      
  u200=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
  rec_num=it*60
  rec_num=rec_num+36
    do il=0,nens-1
      u200(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  u200@units="m/s"      
  u200@long_name="u-velocity at 200hPa"      
  u200!0="time"
  u200!1="lev"
  u200!2="lat"
  u200!3="lon"
  u200&lon=lon
  u200&lat=lat
  u200&lev=lev
  u200&time=tim2
  u200@_FillValue=9.999e+20
  u200@missing_value=9.999e+20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=6      
  v200=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
  rec_num=it*60
  rec_num=rec_num+42
    do il=0,nens-1
      v200(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  v200@units="m/s"      
  v200@long_name="v-velocity at 200hPa"      
  v200!0="time"
  v200!1="lev"
  v200!2="lat"
  v200!3="lon"
  v200&lon=lon
  v200&lat=lat
  v200&lev=lev
  v200&time=tim2
  v200@_FillValue=9.999e+20
  v200@missing_value=9.999e+20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=6      
  u850=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
  rec_num=it*60
  rec_num=rec_num+48
    do il=0,nens-1
      u850(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  u850@units="m/s"      
  u850@long_name="u-velocity at 850hPa"      
  u850!0="time"
  u850!1="lev"
  u850!2="lat"
  u850!3="lon"
  u850&lon=lon
  u850&lat=lat
  u850&lev=lev
  u850&time=tim2
  u850@_FillValue=9.999e+20
  u850@missing_value=9.999e+20
      
      
  tim2=time(0:ntim-1)
  ntim2=dimsizes(tim2)
  nens=6      
  v850=new( (/ntim2,nens,nlat,nlon/), rec_type )
  do it=0,ntim-1
    itt=it-0
  rec_num=it*60
  rec_num=rec_num+54
    do il=0,nens-1
      v850(itt,il,:,:)=fbindirread(path,rec_num,rec_dims,rec_type )
      rec_num=rec_num+1
    end do
  end do
      
  v850@units="m/s"      
  v850@long_name="v-velocity at 850hPa"      
  v850!0="time"
  v850!1="lev"
  v850!2="lat"
  v850!3="lon"
  v850&lon=lon
  v850&lat=lat
  v850&lev=lev
  v850&time=tim2
  v850@_FillValue=9.999e+20
  v850@missing_value=9.999e+20
      
