load "~/ncl/gsn_code.ncl"
load "~/ncl/gsn_csm.ncl"
load "~/ncl/shea_util.ncl"
load "~/ncl/contributed.ncl"
load "./2D_FFT.ncl"

begin

; input directories

; input file
  fili = "lwp.nc"
  fi = addfile(fili,"r")

; data - dimensions
  y = fi->y
  x = fi->x
  xn = dimsizes(x)-1
  yn = dimsizes(y)-1

  Np = dimsizes(x)
  wiw = 1
  Nw = Np/wiw

; data
  lwp = fi->lwp

; do analysis

  ; calculate the 2D wave numbers corresponding to the above amplitudes
  tdf = two_D_frqnc_xy(Np)
  ; calculate the 1D wave numbers
  odf = one_D_frequency(Nw,wiw,0)
  ; calculate the 1D 
  mwn = one_D_frequency(Nw,wiw,1)

  ; perform 2D fft to calculate the amplitudes for all the waves
  amplxy = two_D_fft_xy(lwp,x,y,tdf,Np,0)
  ; perform 2D fft to calculate the energy of all the waves
  enxy = two_D_fft_xy(lwp,x,y,tdf,Np,1)

  ; calculate the spectrum from the above calculated 2D fft
  Sxy = two_to_one_D_spectra_xy(amplxy,enxy,tdf,Np,odf,mwn,2)

; plot
  wks  = gsn_open_wks("x11","proba")
  res = True
  res@vpWidthF = 0.5
  res@vpHeightF = 0.5
  res@gsnMaximize = True
  plot = gsn_csm_contour(wks,amplxy,res)
  res@trXLog = True
  res@trYLog = True
  plot = gsn_csm_xy(wks,odf,Sxy,res)

end

