load "$NCARG_ROOT/lib/ncarg/nclex/gsun/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclex/gsun/gsn_csm.ncl"


begin

  xlat = 12
  ylon = 11

  setfileoption("bin","ReadByteOrder","BigEndian")
  temp = fbinread("./tempfail",(/xlat,ylon/),"float")

  xb = 0
  xe = 11
  yb = 0
  ye = 10

  lonb = -20. + (yb + 3520.)/120.
  late = 90. - (5700. + xe)/120.

  xlat = xe - xb + 1
  ylon = ye - yb + 1
  aux = (/xlat,ylon/)



  LAT = new(xlat,"float")
  LON = new(ylon,"float")
do k=0,(max(aux)-1)
  if (k.lt.xlat) then
    LAT(k) = late + k/120.
  end if
  if (k.lt.ylon)
    LON(k) = lonb + k/120.
  end if
end do
  LATE = LAT((xlat-1):0)


  xwks = gsn_open_wks("x11","Map")
  gsn_define_colormap(xwks,"gui_default")


;----------------------------------------------------------------------
 data     = temp(xb:xe,yb:ye)
 data!0   = "lat"
 data&lat = LATE
 data!1   = "lon"
 data&lon = LON
 data&lat@units = "degrees_north"
 data&lon@units = "degrees_east"
;-------------------------------------------------------------

  res = True
  res@cnFillOn = True
  res@cnLinesOn = False 

  res@cnFillMode = "RasterFill"

  res@gsnAddCyclic = False
  res@mpLimitMode = "LatLon"
  res@mpMinLatF = LATE(xlat-1)
  res@mpMinLonF = LON(0)
  res@mpMaxLatF = LATE(0)
  res@mpMaxLonF = LON(ylon-1)  
  res@tmXBMode = "Automatic"
  res@tmYLMode = "Automatic"
  res@mpMaskOutlineSpecifiers = "Land"
  res@gsnMaximize = True
  res@cnLevelSpacingF = 1.
  plota = gsn_csm_contour_map(xwks,data,res)

end
