load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl"

begin
;
; This file has some funny "^M"'s in it, so I can't read it in column
; by column. Instead, read all the values into one long 1D array, and
; then parse this long array to get every 8th value for each quantity.
;
  values = asciiread("tmax.txt",-1,"float")
  nvals = dimsizes(values)
  ncols = 8
  nrows = ncols/nvals

  lat  = values(::ncols)   
  lon  = values(1::ncols)
  tmax1 = values(2::ncols)
  tmax2 = values(3::ncols)  
  tmax3 = values(4::ncols)  
  tmax4 = values(5::ncols)  
  tmax5 = values(6::ncols)  
  tmax6 = values(7::ncols)

;---Send the graphics to an x11 window. Can use "ps" for PS file.
;--- or png for PNG files
  wks = gsn_open_wks("png","panel")              ; wks for panel

  plot = new(6,graphic)                          ; create a plot array
  
  res          = True
  res@gsnDraw  = False                          ; don't draw
  res@gsnFrame = False                          ; don't advance frame
  res@cnInfoLabelOn = False                     ; turn off cn info label

  res@tmXBLabelsOn         = False              ; do not draw bottom labels
  res@tmXBOn               = False              ; no bottom tickmarks


  gsn_define_colormap(wks,"BlAqGrYeOrReVi200")

;---Set some resources.
  res@gsnMaximize     = True
  res@gsnPaperOrientation   = "Portriat"

;---Lat/lon coordinates for data
  res@sfXArray        = lon
  res@sfYArray        = lat
 
  res@cnLinesOn       = False
  res@cnFillOn        = True
  res@cnFillMode      = "AreaFill"      ; The default.
  res@lbLabelBarOn    = False           ; turn off individual cb's

;  res@cnFillMode          = "RasterFill"    ; Uncomment for "blocky" fill
;  res@cnRasterSmoothingOn = True

;---Zoom in on map
  res@mpMinLatF       = min(lat)
  res@mpMaxLatF       = max(lat)
  res@mpMinLonF       = min(lon)
  res@mpMaxLonF       = max(lon)
  
  res@lbOrientation   = "Vertical"

  res@gsnSpreadColors      = True
  res@cnLevelSelectionMode = "ManualLevels"
  res@cnMinLevelValF       = 25.
  res@cnMaxLevelValF       = 35.
  res@cnLevelSpacingF      =  0.5
 

;---This will cause any contours over the ocean to be masked.
  res@mpDataSetName         = "Earth..4"   ; This new database contains
                                           ; divisions for other countries.
  res@mpDataBaseVersion     = "MediumRes"  ; Medium resolution database

  res@mpOutlineOn           = True         	  ; Turn on map outlines
  res@mpFillOn              = True                ; turn on map fill
  res@mpLandFillColor       = "Background"        ; set to white
  res@mpFillDrawOrder      = "PostDraw"
;  res@mpLandFillColor      = "transparent"
;  res@mpOceanFillColor     = "cyan"

  res@mpFillAreaSpecifiers        = (/"Tamil Nadu", "Land", "Water"/)
  res@mpSpecifiedFillColors       = (/"transparent","white","white"/)

  res@mpOutlineSpecifiers   = (/"India:states:Tamil Nadu"/)  
 
; Tamil Nadu  limits
  res@mpMinLatF             =  7.9        
  res@mpMaxLatF             =  13.7
  res@mpMinLonF             =  76.0
  res@mpMaxLonF             =  80.5

;---Turn on "fancy" tickmark labels.
  
  res@pmTickMarkDisplayMode = "Always"
  delete(res@tmXBLabelsOn)
  delete(res@tmXBOn)
  res@tmXBLabelFontColor = "white"
  res@tmXBLabelFontHeightF      = 0.015   ; Make slightly larger
  res@tmYLLabelFontHeightF      = 0.015

  plot(0) = gsn_csm_contour_map(wks,tmax1,res)

  plot(1) = gsn_csm_contour_map(wks,tmax2,res)

  plot(2) = gsn_csm_contour_map(wks,tmax3,res)

  delete(res@tmXBLabelFontColor)

  plot(3) = gsn_csm_contour_map(wks,tmax4,res)

  plot(4) = gsn_csm_contour_map(wks,tmax5,res)

  plot(5) = gsn_csm_contour_map(wks,tmax6,res)

;************************************************
; create panel
;************************************************
  resP                   = True
  resP@txString          = "RegCM4 decadal mean maximum temperature (:S:o:N:C)"
  resP@txFontHeightF     =  .025
  resP@gsnPanelLabelBar    = True                ; add common colorbar
  resP@lbLabelFontHeightF  = 0.012               ; make labels smaller
  resP@vpWidthF            = .9                 ; Change width and height 
  resP@vpHeightF           = 0.06              ; of labelbar. 
  resP@gsnPanelYWhiteSpacePercent = 5
  resP@gsnPanelXWhiteSpacePercent = 5

  resP@gsnPanelFigureStrings= (/"1971-1980","1981-1990","1991-2000","2001-2010","2011-2020","2021-2030"/) ; add strings to panel
  resP@gsnPanelFigureStringsFontHeightF= 0.0105
  resP@amJust = "TopLeft"
  resP@gsnPanelFigureStringsPerimOn = False

  gsn_panel(wks,plot,(/2,3/),resP)             ; now draw as one plot

end
