;   Example script - plot terrain (using some basic WRF scripts)
;   The map background is added via the special wrf_map_overlays function
;   We get the HGT_M field using the special function wrf_user_getvar
;   November 2008

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "./gsn_code.ncl"
;load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/wrf/WRFUserARW.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"

begin

nrows_dots = numAsciiRow("eval_dots.txt")
ncolumns_dots = numAsciiCol("eval_dots.txt")

table_dots = asciiread("eval_dots.txt",nrows_dots,"string")

delim=","

lats_dots=stringtofloat(str_get_field(table_dots(1:nrows_dots-1),2,delim))
lons_dots=stringtofloat(str_get_field(table_dots(1:nrows_dots-1),3,delim))
bias_dots=stringtofloat(str_get_field(table_dots(1:nrows_dots-1),5,delim))
prmse_dots=stringtofloat(str_get_field(table_dots(1:nrows_dots-1),6,delim))

corr_dots=stringtofloat(str_get_field(table_dots(1:nrows_dots-1),7,delim))

symbols_dots = onedtond("string",(nrows_dots-1))

  a = addfile("./geo_em.d01.nc","r")           ; Open a file


; type = "x11"
; type = "pdf"
; type = "eps"
; type = "ps"
; type = "ncgm"
 type = "png"
 wks = gsn_open_wks(type,"dots_stations")     

setvalues NhlGetWorkspaceObjectId()
  "wsMaximumSize": 247108864
end setvalues

    ; Create a plot workstation


  opts = True                          
        ; Set some Basic Plot options
;  opts@MainTitle = "GEOGRID FIELDS"
opts@InitTime = False
opts@NoHeaderFooter = True
opts@Footer = False
opts@cnInfoLabelOn        = False
opts@cnConstFLabelOn      = False
opts@cnFillOn            = True
opts@cnLinesOn = False



  ter = wrf_user_getvar(a,"HGT",0)          
 ; Read the variable to memory
  lmask = wrf_user_getvar(a,"LANDMASK",0)      
     ; Read the variable to memory

;  res = opts                                
   ; Use basic options for this field
;  res@cnFillOn = True                      
    ; Create a color fill plot

   opts_ter = opts

   opts_ter@UnitLabel            = "m"
;   opts_ter@cnLevelSelectionMode = "ExplicitLevels"
;   opts_ter@cnLevels  = (/ .1, 500, 1000, 1500, 2000, 2500, 3000, 3500/)
;   opts_ter@cnFillColors = (/"Blue","DarkOliveGreen1",\
;                        "DarkOliveGreen3", \
;                        "Chartreuse",     "Chartreuse3", \
;                        "Green",          "ForestGreen", \
;                        "Yellow",         "Orange", \
;                        "Red",             "Violet"/)


;  opts_ter@cnFillColors = (/"Blue", \
;                        "Green3", "Green",  \
;                        "Chartreuse",     "Yellow3", \
;                        "Yellow",         "Orange", \
;                        "Red",             "Red3"/)



  opts_ter@gsnMaximize = True
  opts_ter@gsnPaperOrientation = "Landscape"
;  opts_ter@MainTitle = "Terrain Elevation"
  opts_ter@FieldTitle = "Terrain Elevation"
; opts_ter@ContourParameters = (/ 100. /)
  opts_ter@cnInfoLabelOn = False
;  contour_ter = wrf_contour(a,wks,ter,opts_ter)

   opts_lmask = opts

   opts_lmask@UnitLabel            = ""
   opts_lmask@cnLevelSelectionMode = "ExplicitLevels"
   opts_lmask@cnLevels  = (/0.,.5/)

  opts_lmask@gsnMaximize = True
  opts_lmask@cnFillColors = (/"Transparent","Transparent","Transparent"/)
  opts_lmask@FieldTitle = ""
  opts_lmask@lbLabelBarOn = False

  contour_lmask = wrf_contour(a,wks,lmask,opts_lmask)

  pltres = True                                ; Set plot options
  mpres = True
  mpres@mpFillOn = True
;  mpres@mpFillColors  = (/"background","transparent","transparent","transparent", "transparent"/)
  mpres@mpFillColors  = (/"background","DeepSkyBlue","OliveDrab1","DeepSkyBlue", "transparent"/)
;  mpres@mpFillColors  = (/"background","DeepSkyBlue","GreenYellow","DeepSkyBlue", "transparent"/)

  mpres@mpGeophysicalLineColor      = "Black"
  mpres@mpGridLineColor             = "Black"
  mpres@mpLimbLineColor             = "Black"
  mpres@mpNationalLineColor         = "Black"
  mpres@mpPerimLineColor            = "Black"
  mpres@mpUSStateLineColor          = "Black"

  plot = wrf_map_overlays(a,wks,(/contour_lmask/),\
         pltres,mpres)

;  gsn_define_colormap(wks,"BlWhRe")
;  gsn_define_colormap(wks,"ncl_default")

  txres               = True
  txres@txFontHeightF = 0.015
  txres@txFont        = "weather2"

  symbols_dots="m"

  colors = (/"Blue","White","Red"/)

  opt = True
  opt@NumColorsInRange = (/10,10/)
	
  rgb_array = span_named_colors(colors,opt)

  i=0

  do while (i.le.(nrows_dots-2)) 
;  do while (i.le.200) 

  if (bias_dots(i) .le. -5 ) then
     txres@txFontColor        = colors(0)
  end if  

  if ( (bias_dots(i) .gt. -5) .and. (bias_dots(i) .le. 5) ) then
     txres@txFontColor        = colors(1)
  end if


  if (bias_dots(i) .gt. 5 ) then
     txres@txFontColor        = colors(2)
  end if

  text_dots  = gsn_add_text(wks,plot,\
                  symbols_dots(i),\
  lons_dots(i),lats_dots(i),txres)

  i=i+1

  end do


;  text_dots  = gsn_add_text(wks,plot,\
;                  symbols_dots(0:nrows_dots-2),\
;  lons_dots(0:nrows_dots-2),lats_dots(0:nrows_dots-2),txres)


  draw(plot)      ; Now draw map with text strings and
  frame(wks)

end
