load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "ESMF_regridding.ncl"

begin

  grid_file   = "grid.nc"
  esmf_file   = "esmf_grid.nc"
  scrip_file  = "2.5x2.5_scrip.nc"
  weight_file = "weight_file.nc"

  f = addfile(grid_file, "r")

  lat_in = f->lat
  lon_in = f->lon

  delete(f)

  Opt                = True
  Opt@ForceOverwrite = True

  unstructured_to_ESMF(esmf_file, lat_in, lon_in, Opt)
  delete(Opt)

  Opt                = True
  Opt@ForceOverwrite = True
  Opt@Title          = "2.5 x 2.5 degree grid"

  latlon_to_SCRIP(scrip_file,"2.5x2.5deg",Opt)
  delete(Opt)

  Opt              = True
  Opt@InterpMethod = "bilinear"
  Opt@SrcESMF      = True

  ESMF_regrid_gen_weights(esmf_file, scrip_file, weight_file, Opt)


end