load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl"

begin

; t, z, lat, lon
; t=2192 times
f1 = addfile("../../../inland/input/daily/tmp/wspd.2000.2005.nc","r")
; t=1095 times
;f2 = addfile("../../../inland/input/daily/tmp/wspd.2001.2003.nc","r")

; t, lat, lon
; t=2192 times
f3 = addfile("km34.diario.inland2d.2000.2005.nc","r")
; t=1095 times
;f4 = addfile("km83.diario.inland2d.2001.2003.nc","r")

v1 = f1->wspd(:,0,{-3.25},{-54.75})
;v2 = f2->wspd(:,0,{-3.25},{-54.75})
v3 = f3->vento(:,0,0)
;v4 = f4->vento(:,0,0)

x = dimsizes(v1)

print("a -> " + dimsizes(v1) + " b -> " + dimsizes(v3) )

data      = new((/2,dimsizes(v1)/),float)
data(0,:) = v1
data(1,:) = v3

wks = gsn_open_wks("x11","teste")

res             = True
res@gsnDraw     = True
res@gsnFrame    = True

plot  = gsn_csm_xy (wks,x,data,res)


end


