load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl"  
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl"

begin

atilde = "a~H-13V2F35~D~FV-2H3~"  ; ã
iacute = "i~H-08V2F35~B~FV-2~"    ; í
eacute = "e~H-13V2F35~B~FV-2H3~"  ; é
cedil  = "c~H-13F35~K~FH2~"       ; ç
aacute = "a~H-13V2F35~B~FV-2H3~"  ; á
ecirc  = "e~H-13V2F35~C~FV-2H3~"  ; ê
eacute = "e~H-13V2F35~B~FV-2H3~"  ; é
oacute = "o~H-13V2F35~B~FV-2H3~"  ; ó

print("abertura dos arquivos")

do i = 0,3

t       = (/"djf","mam","jja","son"/)
estacao = (/"DJF","MAM","JJA","SON"/)

print("") 
print("Estacao ==> " + estacao(i))
print("") 

f1 = addfile("mcga.corr.prec."+t(i)+".nc","r")
f2 = addfile("gpcp.prec."+t(i)+".nc","r")

prec_mod = f1->prec
prec_obs = f2->precip

x = prec_mod
y = prec_obs

med_mod = dim_avg_n_Wrap(prec_mod,0)
med_obs = dim_avg_n_Wrap(prec_obs,0)
dif     = med_mod - med_obs
copy_VarCoords(med_mod,dif)

prob = new((/72,144/),float) ; tive que criar uma variável vazia com nlat=72 e nlon=144. 
                             ; Mesma dimensão do arquivo original de PRP
prob!0 = "lat"                    ; nome da primeira dimensão
prob!1 = "lon"                    ; nome da segunda dimensão
prob&lat=fspan(-88.75,88.75,72)   ; crio um vetor com as posições de lat
prob&lon=fspan(1.25,358.75,144)   ; crio um vetor com as posições de lon
prob&lat@units = "degrees_north"  ; adicion referência a lat
prob&lon@units = "degrees_east"   ; adicion referência a lon

dimXY = dimsizes(x)
ntim  = dimXY(0)
nlat  = dimXY(1)
mlon  = dimXY(2)

xtmp = x(lat|:,lon|:,time|:)       ; reorder but do it only once [temporary]
ytmp = y(lat|:,lon|:,time|:)
    
xAve = dim_avg (xtmp)              ; calculate means at each grid point 
yAve = dim_avg (ytmp)
xVar = dim_variance (xtmp)         ; calculate variances
yVar = dim_variance (ytmp)

sigr = 90.                        ; critical sig lvl for r
xEqv = equiv_sample_size (xtmp, sigr,0)
yEqv = equiv_sample_size (ytmp, sigr,0)

iflag= False                        ; population variance similar

print("calculando o teste de significancia")

prob = 100.*(1.-ttest(xAve,xVar,ntim,yAve,yVar,ntim,iflag,False))

wks = gsn_open_wks("eps","xxx") 

gsn_define_colormap(wks,"hotcold_18lev")

plot  = new(4,graphic)

res                               = True
res@gsnDraw                       = False
res@gsnFrame                      = False
res@gsnMajorLonSpacing            = 60
res@gsnMajorLatSpacing            = 30
res@cnFillOn                      = True
res@cnLinesOn                     = False
res@mpMinLonF                     = 0
res@mpMaxLonF                     = 360
res@mpCenterLonF                  = 180               ; This is necessary to get the correct map
res@mpOutlineBoundarySets         = "National"        ; mostra divisao dos paises
res@mpFillOn                      = False             ; turn off gray map
res@cnLevelSelectionMode          = "ExplicitLevels"  ; set explicit contour levels
res@gsnStringFontHeightF          = 0.03              ; aumenta fonte do lado esquerdo, centro e direito
res@tmXBLabelFontHeightF          = 0.015             ; tamanho da fonte do eixo x
res@tmYLLabelFontHeightF          = 0.015             ; tamanho da fonte do eixo y
res@lbOrientation                 =  "vertical"       ; vertical label bar
res@tmXBMinorOn                   = False             ; desliga o minortick do eixo x
res@tmYLMinorOn                   = False
res@lbLabelStride                 = 2                 ; skip every other label
res@lbLabelFontHeightF            = .025              ; default is HUGE
res@gsnCenterString               = "1986-2005" 
res@cnLevels                      = (/-10,-8,-6,-4,-2,-1,0,1,2,4,6,8,10/)
res@cnFillColors                  = (/18,17,16,15,14,13,11,11,9,8,7,6,5,4/)
res@gsnRightString                = estacao(i)
res@gsnLeftString                 = "MCGA-GPCP"
res@lbLabelBarOn                  = False                ; habilita a legenda
res@cnLineLabelsOn                = False                ; desabilita as linhas

plot(i) = gsn_csm_contour_map_ce(wks,dif,res)

sres                       = True                  ; res2 probability plots
sres@gsnDraw               = False                 ; Do not draw plot
sres@gsnFrame              = False                 ; Do not advance frome
sres@cnFillOn              = False   
sres@cnInfoLabelOn         = False
sres@cnLinesOn             = False                 ; do not draw contour lines
sres@cnLineLabelsOn        = False                 ; do not draw contour labels
sres@cnFillScaleF          = 0.6                   ; add extra density
sres@gsnAddCyclic          = True

plot2 = gsn_csm_contour(wks,prob,sres)

opt                   = True
opt@gsnShadeFillType  = "pattern"
opt@gsnShadeHigh      = 17  

print("sobreposicao dos campos")

plot2 = gsn_contour_shade(plot2,x@_FillValue,sigr,opt)

overlay (plot(i),plot2)
;draw (plot)
;frame(wks)

end do	

print("")
print("criando o painel")
print("")

resP                                    = True
resP@txString                           = "Precipita"+cedil+atilde+"o (mm dia~S~-1~N~)"
resP@gsnFrame                           = False
resP@gsnPanelFigureStrings              = (/"a)","b)","c)","d)"/)
resP@gsnPanelFigureStringsFontHeightF   = 0.013
resP@amJust                             = "TopRight"
resP@gsnPanelFigureStringsPerimOn       = False
resP@gsnPanelYWhiteSpacePercent         = 5 ; adiciona espaçamento na direção Y
resP@gsnPanelXWhiteSpacePercent         = 3 ; adiciona espaçamento na direção X
resP@gsnPanelLabelBar                   = True                 ; add common colorbar
resP@lbTitleOn                          =  True                ; turn on title
resP@lbTitleString                      = "(mm dia~S~-1~N~)"            ; title string
resP@lbTitlePosition                    = "Top"                ; title position
resP@lbTitleFontHeightF                 = 0.018                ; make title smaller
resP@lbTitleDirection                   = "Across"             ; title direction
resP@lbLabelFont                        = "Helvetica"     ; label font

gsn_panel(wks,plot,(/2,2/),resP)

end
