;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; O DADO DE ENTRADA DEVE CONTER TODOS OS MESES. NÃO PODE TER ANO INCOMPLETO
; DE MESES
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl" 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl" 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl" 
load "evans_plot.ncl"

begin

atilde = "a~H-13V2F35~D~FV-2H3~"  ; ã
cedil  = "c~H-13F35~K~FH2~"       ; ç

arquivo = "cmap.nc" ; nome do seu arquivo de entrada

a    = addfile(arquivo,"r") ; abertura do arquivo

ylat = a->lat      ; carrego algumas variáveis
xlon = a->lon      ; carrego algumas variáveis
u    = a->precip   ; carrego algumas variáveis

dim = dimsizes(u)
nt  = dim(0) ; número de tempos do arquivo
ny  = dim(1) ; número de pontos em y
nx  = dim(2) ; número de pontos em x

print("Numero de tempos              : " + nt)
print("Numero de pontos de latitude  : " + ny)
print("Numero de pontos de longitude : " + nx)

var_new = new((/ny,nx/),"float",getFillValue(u)) ; variável que conterá os valores máximos, tem que ser do
                                                 ; tipo var(lat,lon)

var_new!0          = "lat"                  ; crio a dimensão lat
var_new!1          = "lon"                  ; crio a dimensão lon
var_new&lat        = fspan(88.75,-88.75,ny) ; informações obtidas com o prinVarSummary. São as coordenadas da lat 
var_new&lon        = fspan(1.25,358.75,nx)  ; informações obtidas com o prinVarSummary. São as coordenadas da lon
var_new&lat@units  = "degrees_north"        ; unidade da latitude
var_new&lon@units  = "degrees_east"         ; unidade da longitude

tempo = new((/ny,nx/),"float",getFillValue(u)) ; variável que conterá os valores máximos, tem que ser do
                                               ; tipo tempo(lat,lon)
tempo!0          = "lat"
tempo!1          = "lon"
tempo&lat        = fspan(88.75,-88.75,ny) ; informações obtidas com o prinVarSummary 
tempo&lon        = fspan(1.25,358.75,nx)  ; informações obtidas com o prinVarSummary 
tempo&lat@units  = "degrees_north"
tempo&lon@units  = "degrees_east"

do lat = 0,ny-1
   do lon = 0,nx-1
      var              = u(:,lat,lon)                            ; varredura de todos os tempos (:) para cada lat/lon
      max_var          = max(var)                                ; obtenho para todos os tempos o valor máximo da variável em cada lat/lon.
      index            = mod( get1Dindex(var,max_var),12 ) + 1   ; obtenho o mês para cada valor máximo e somo 1 pq os meses começam em zero (índices).
      var_new(lat,lon) = max_var                                 ; preencho a variável com os máximos valores.
      tempo(lat,lon)   = index                                   ; preencho o vetor do tempo com a variável "index" .
      print("lat_i:  " + lat + "     lon_j:  " + lon + "     valor:  " + max_var + "    mes:  " + index)
   end do  
end do

printMinMax (var_new, True)

wks_type                = "eps"
wks_type@wkOrientation = "landscape"
wks = gsn_open_wks(wks_type,"01evans_plot")

wks = gsn_open_wks("pdf","01evans_plot")

res                             = True
res@gsnMaximize                 = True
res@tiMainString                = " "
res@gsnLeftString               = "Fonte: GPCP-1979/2012"
res@gsnRightString              = "(mm dia~S~-1~N~)"
res@gsnCenterString             = "Precipita"+cedil+atilde+"o"
res@gsnMajorLonSpacing          = 30
res@gsnMajorLatSpacing          = 20
res@gsnStringFontHeightF        = 0.015             ; aumenta fonte do lado esquerdo, centro e direito
res@mpOutlineDrawOrder          = "PostDraw" 
res@mpGridLineDashPattern       = 2          
res@mpPerimOn                   = True
res@mpPerimDrawOrder            = "PostDraw"
res@mpOutlineOn                 = True
res@mpOutlineBoundarySets       = "National"      ; mostra divisao dos países
res@mpDataSetName               = "Earth..4"
res@mpDataBaseVersion           = "MediumRes"
res@mpOutlineOn                 = True
res@mpOutlineSpecifiers         = (/"Brazil:states"/)
res@mpGeophysicalLineThicknessF = 1.5
res@mpCenterLonF                = 180
res@mpMinLatF                   = -40
res@mpMaxLatF                   = 40
res@tmXBMinorOn                 = False             ; desliga o minortick do eixo x
res@tmYLMinorOn                 = False
res@tmXBLabelFontHeightF        = 0.012             ; tamanho da fonte do eixo x
res@tmYLLabelFontHeightF        = 0.012             ; tamanho da fonte do eixo y
res@epCyclic                    = True
res@epMinHueLevel               = 1.                ; primeiro valor da legenda (mês)
res@epMaxHueLevel               = 12.               ; último valor da legenda (mês)
res@epHueLevelSpacing           = 1                 ; espaçamento dos valores (mês)
res@epColorWheelPerimOn         = False             ; desliga a caixa em volta da legenda
res@epColorWheelScale           = 0.6               ; tamanho da legenda
res@epColorWheelCenterX         = 0.47              ; posição x da legenda
res@epColorWheelCenterY         = 0.15              ; posição y da legenda
res@epMinIntensity              = 1.0               ; mapa com fundo branco
res@epMinSatLevel               = 10                ; intervalo de valores inferior da legenda
res@epMaxSatLevel               = 40                ; intervalo de valores superior da legenda
res@epSatLevelSpacing           = 5                ; espaçamento dos valores da legenda
res@epHueLabel                  = "(mm dia~S~-1~N~)"

;plot = evans_plot_map(wks,tempo,var_new,res)

end


