load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_code.ncl"
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/gsn_csm.ncl" 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/contributed.ncl" 
load "$NCARG_ROOT/lib/ncarg/nclscripts/csm/shea_util.ncl" 

begin

fq = addfile("q1.nc","r") ; 50 years
fu = addfile("u1.nc","r") ; 50 years
fv = addfile("v1.nc","r") ; 50 years
fp = addfile("p1.nc","r") ; 50 years

q    = fq->hus ; float hus(time, plev, lat, lon) ; 100000,92500,85000,70000,60000,50000,40000,30000 => z = 8
u    = fu->ua  ; float ua(time, plev, lat, lon)  ; 100000,92500,85000,70000,60000,50000,40000,30000 => z = 8
v    = fv->va  ; float va(time, plev, lat, lon)  ; 100000,92500,85000,70000,60000,50000,40000,30000 => z = 8
psfc = fp->ps  ; float ps(time, lat, lon)

qc = clmMonTLLL(q)   ; [month | 12] x [plev | 8] x [lat | 28] x [lon | 35]
uc = clmMonTLLL(u)   ; [month | 12] x [plev | 8] x [lat | 28] x [lon | 35]
vc = clmMonTLLL(v)   ; [month | 12] x [plev | 8] x [lat | 28] x [lon | 35]
pc = clmMonTLL(psfc) ; [month | 12] x [lat | 28] x [lon | 35]

lat = fq->lat
lon = fq->lon
p   = fq->plev

uq  = uc*(qc*1e3) ; kg/kg -> g/kg
vq  = vc*(qc*1e3) ; kg/kg -> g/kg

divc = uv2dv_cfd (uq,vq,lat,lon, 0)*1e5  ; divergence [kg/(m-1 s-1)] --> [month | 12] x [plev | 8] x [lat | 28] x [lon | 35]

copy_VarCoords(qc,divc)

pbot   = 110000. ; Pa
ptop   = 30000.  ; Pa
linlog = 1       ; 1 = linear interpolation ; 2 = log interpolation

print(dimsizes(divc))
print("-----")
print(dimsizes(pc))

; vertically integrated moisture flux (10^7 kg s-1)
fint = vibeta(p,divc(month|:,lat|:,lon|:,plev|:),linlog,pc,pbot,ptop)

printVarSummary(fint)

wks = gsn_open_wks("eps","teste")

gsn_define_colormap(wks,"temp_diff_18lev")

res                        = True
res@cnFillOn               = True
res@cnLinesOn              = False
res@cnFillMode             = "RasterFill"
res@gsnAddCyclic           = False
res@mpMinLonF              = -80.
res@mpMaxLonF              = 5.
res@mpMinLatF              = -35.
res@mpMaxLatF              =  35.

;plot = gsn_csm_contour_map(wks,fint(0,:,:),res) 

end


